<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAvailabilityTable extends Migration
{
    public function up()
    {
        Schema::create('availability', function (Blueprint $table) {
            $table->bigIncrements('availability_id');
            $table->bigInteger('profile_id')->unsigned()->notNullable();
            $table->enum('day_of_week', ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'])->nullable();
            $table->enum('time_slot', ['Morning', 'Afternoon', 'Evening'])->notNullable();
            $table->enum('status', ['available', 'no_data', 'booked'])->default('no_data');
            $table->tinyInteger('is_recurring')->default(1);
            $table->string('timezone', 50)->default('America/Toronto');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();

            $table->foreign('profile_id')->references('Profile_id')->on('candidate_profiles')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('availability');
    }
}
